---
name: research-trends-development
description: >
  Research competitor trends and development signals for CompetitiveOS. Use when analyzing
  hiring patterns, product launches, funding rounds, patents, leadership changes, or strategic
  direction. Covers forward-looking signals about the competitor's trajectory.
---

# Research: Trends & Development (trends_development)

Capture signals about where the competitor is heading. What are they building? Who are they hiring? Have they raised funding? This dimension is forward-looking – it's about trajectory, not current state.

## Data Points to Capture

| Key | Priority | Description | Example |
|---|---|---|---|
| `hiring_signals` | required | Current hiring focus areas | "Hiring 5 ML engineers + 3 enterprise AEs → AI + enterprise push" |
| `recent_launches` | required | Recent product/feature launches | "Launched AI assistant feature (Q4 2025), new mobile app (Q3 2025)" |
| `funding` | required | Funding history | "Series B: $25M (Jan 2025), total raised: $38M" |
| `strategic_direction` | required | Overall strategic trajectory | "Moving upmarket: enterprise features, SOC 2, dedicated CSMs" |
| `product_roadmap` | recommended | Known roadmap items | "Public roadmap shows API v2, SSO, and workflow automation planned" |
| `revenue_signals` | recommended | Revenue/growth signals | "Claims 3x YoY growth, 500+ enterprise customers" |
| `acquisitions` | recommended | Acquisitions/partnerships | "Acquired DataViz startup (Sept 2025) for visualization capabilities" |
| `trends_vs_own` | recommended | Development comparison to own | "Investing heavily in AI while we focus on manual workflows" |
| `valuation` | optional | Known valuation | "Valued at ~$150M post Series B" |
| `patents` | optional | Patent filings | "2 patents filed for ML-based competitive analysis (US Patent Office)" |
| `leadership_changes` | optional | Key leadership changes | "New CRO hired from Salesforce (Nov 2025) → enterprise sales push" |
| `market_expansion` | optional | Geographic/market expansion | "Opened DACH office in Berlin, German website launched" |

> **Priority Guide:** `required` keys are the minimum for a useful analysis. Start with these under time pressure. `recommended` keys form the standard scope. `optional` keys add depth for comprehensive analyses. Use `add_data_points` (batch) when capturing 3+ data points for the same competitor and dimension.

## Research Sources by Priority

### Primary (Confidence: high)
1. **Crunchbase** – Funding rounds, investors, key people, acquisitions. Most reliable for funding data.
2. **LinkedIn company page** – Employee count trends, open positions, new hires. Use "People" tab + job postings.
3. **Company blog/newsroom** – Product announcements, partnership news, milestone posts.
4. **Press releases** – PR Newswire, BusinessWire. Official announcements about funding, launches, partnerships.

### Secondary (Confidence: medium)
5. **TechCrunch / industry press** – Third-party coverage of funding, launches, pivots.
6. **Product Hunt** – New launches and feature announcements. Shows what they want to highlight.
7. **GitHub activity** – For open source products: commit frequency, new repos, contributor growth.
8. **Public roadmap** – Some companies publish roadmaps (e.g. on Canny, ProductBoard, or their own site).

### Tertiary (Confidence: low)
9. **Glassdoor** – Employee reviews can reveal internal strategy, morale, and direction.
10. **Patent databases** – Google Patents, USPTO, EPO. Patent filings reveal R&D direction.
11. **Social media** – CEO/founder posts on LinkedIn/Twitter often hint at strategic direction.
12. **Conference talks** – Recent talks reveal what problems they're solving next.

## Common Pitfalls

- **Hiring != Building:** Job postings show intent, not shipped features. Note as signals, not confirmed capabilities.
- **Funding != Success:** A large funding round means runway, not product-market fit. Don't overinterpret funding news.
- **Press releases are marketing:** Companies announce what they want you to know. Look for what they don't announce too.
- **LinkedIn employee count fluctuations:** LinkedIn numbers are approximate. Small changes (<10%) may be noise.
- **Outdated signals:** A funding round from 18 months ago is background info, not a current trend. Focus on last 6-12 months.
- **Confirmation bias:** Don't only look for signals that confirm your hypothesis. Capture contradictory signals too.

## Quality Checks

- Funding data sourced from Crunchbase or press (not guessed)?
- Hiring signals based on actual job postings (not assumptions)?
- Recent product launches captured with approximate dates?
- Strategic direction supported by multiple signals (not just one data point)?
- Comparison to own trajectory created?
