---
name: research-technology
description: >
  Research competitor technology stack and technical capabilities for CompetitiveOS. Use when analyzing
  tech stack, APIs, integrations, mobile apps, security certifications, or technical infrastructure.
  Covers the technical foundation and capabilities of the competitor's product.
---

# Research: Technology & Infrastructure (technology)

Capture the competitor's technical foundation. What technologies do they use? What APIs/integrations do they offer? What is their mobile strategy? How does their technical approach compare to the user's own?

## Data Points to Capture

| Key | Priority | Description | Example |
|---|---|---|---|
| `tech_stack` | required | Known technology stack | "React frontend, Python/Django backend, AWS hosting" |
| `api_available` | required | Public API availability | "REST API, documented at docs.competitor.com/api" |
| `integrations` | required | Available integrations | "Slack, HubSpot, Salesforce, Zapier (50+ integrations)" |
| `tech_vs_own` | required | Tech comparison to own | "More integrations but no public API vs. our API-first approach" |
| `hosting` | recommended | Hosting/infrastructure | "AWS eu-west-1, CloudFlare CDN" |
| `security_certs` | recommended | Security certifications | "SOC 2 Type II, GDPR compliant, ISO 27001" |
| `mobile_app` | recommended | Mobile app availability | "iOS and Android native apps, 4.2 star rating" |
| `sso_support` | recommended | SSO/enterprise auth | "SAML SSO, SCIM provisioning on Enterprise plan" |
| `api_type` | optional | API type and quality | "REST with OpenAPI spec, rate limited to 1000 req/min" |
| `uptime_sla` | optional | Uptime/SLA guarantees | "99.9% uptime SLA on Enterprise plan" |
| `data_residency` | optional | Data residency options | "EU and US data centers available" |
| `open_source` | optional | Open source components | "Core engine open source on GitHub (2.3K stars)" |

> **Priority Guide:** `required` keys are the minimum for a useful analysis. Start with these under time pressure. `recommended` keys form the standard scope. `optional` keys add depth for comprehensive analyses. Use `add_data_points` (batch) when capturing 3+ data points for the same competitor and dimension.

## Research Sources by Priority

### Primary (Confidence: high)
1. **Developer/API documentation** – Check /docs, /api, /developers. Best source for API capabilities and tech decisions.
2. **Status page** – Usually status.competitor.com. Reveals infrastructure, uptime history, incident frequency.
3. **Security/compliance page** – /security, /trust, /compliance. Certifications, data handling policies.
4. **App Store / Google Play** – Mobile app existence, ratings, last update date, feature list.

### Secondary (Confidence: medium)
5. **BuiltWith / Wappalyzer** – Technology detection for frontend stack, analytics, hosting.
6. **GitHub** – Public repos, open source activity, tech blog posts about architecture.
7. **Integration marketplace** – Zapier, Make.com – shows available integrations and automation capabilities.
8. **Job postings** – Engineering job descriptions reveal tech stack (e.g. "Experience with Kubernetes" = K8s infrastructure).

### Tertiary (Confidence: low)
9. **Tech blog posts** – Company engineering blog reveals architecture decisions and scale.
10. **Conference talks** – Engineering talks on YouTube/SlideShare about their architecture.
11. **LinkedIn employee profiles** – Engineers' skills and experience hint at tech stack.

## Common Pitfalls

- **Frontend != Backend:** BuiltWith shows frontend technologies. Backend stack requires other sources (job posts, blog, GitHub).
- **Integration count vs. quality:** "50+ integrations" sounds impressive but check depth. Many are just Zapier triggers, not native integrations.
- **Security claims vs. certifications:** "We take security seriously" is marketing. SOC 2 Type II is a certification. Distinguish between claims and verified certifications.
- **Outdated mobile apps:** Check last update date. An app last updated 2 years ago is effectively abandoned.
- **API documentation gaps:** Having an API page doesn't mean the API is good. Check for OpenAPI spec, SDKs, rate limits, and authentication method.

## Quality Checks

- Tech stack sourced from multiple signals (not just BuiltWith)?
- API capabilities documented with link to documentation?
- Security certifications verified (not just claimed)?
- Mobile app checked with rating and last update date?
- Comparison to own technical approach created?
