---
name: research-target-audience
description: >
  Research competitor target audiences for CompetitiveOS. Use when analyzing who a competitor
  serves: B2B vs B2C, company sizes, industries, job roles, experience levels, geographic focus.
  Covers identification from pricing signals, testimonials, and content strategy.
---

# Research: Target Audience (target_audience)

Capture who the competitor addresses. B2B or B2C? Which industries? What experience level? This is critical to understand overlap with the user's own offering.

## Data Points to Capture

| Key | Priority | Description | Example |
|---|---|---|---|
| `target_segment` | required | Main target (B2B, B2C, both) | "B2B + B2C" |
| `company_size` | required | Company size (if B2B) | "SMB (10-500 employees)" |
| `industries` | required | Target industries | "Tech, Finance, Manufacturing" |
| `use_case` | required | Primary use case | "Professional development", "Career change to Data Science" |
| `job_roles` | recommended | Target roles/positions | "Data Scientists, Product Managers, Executives" |
| `geographic_focus` | recommended | Geographic focus | "DACH", "Europe", "Global" |
| `customer_examples` | recommended | Known customers/references | "Logo wall: BMW, Siemens, Allianz" |
| `pricing_signals` | recommended | What pricing says about target group | "Enterprise pricing → B2B focus" |
| `experience_level` | optional | Experience level | "Beginner to Advanced" |
| `language_market` | optional | Language market | "German-speaking", "English-speaking", "Both" |
| `testimonials_persona` | optional | Who gives testimonials? | "Mainly IT directors and HR managers" |

> **Priority Guide:** `required` keys are the minimum for a useful analysis. Start with these under time pressure. `recommended` keys form the standard scope. `optional` keys add depth for comprehensive analyses. Use `add_data_points` (batch) when capturing 3+ data points for the same competitor and dimension.

## Research Sources by Priority

### Primary (Confidence: high)
1. **"For whom" page / About page** – Many providers describe their target group explicitly. Look for "For companies", "For individuals", "Who is this for?".
2. **Customer references / logo wall** – Which companies are shown as customers? This reveals the actual target group better than any description.
3. **Testimonials** – Who gives reviews? Job titles and companies in testimonials reveal the real target audience.
4. **Pricing page** – Pricing structure itself is a target group signal. "Per employee" = B2B. "One-time payment 49€" = B2C. "On request" = Enterprise.

### Secondary (Confidence: medium)
5. **LinkedIn ads** – LinkedIn Ad Library shows who ads target (job titles, industries, company sizes).
6. **Content topics** – What do they blog about? "10 AI tools for SMBs" → B2B SMB. "Career in Data Science" → B2C career changers.
7. **Case studies** – Detailed customer stories show the ideal customer profile.

### Tertiary (Confidence: low)
8. **Social media followers** – Who follows the company? What comments are posted?
9. **Event participation** – Which trade shows/conferences do they attend? B2B events vs. open conferences.

## Common Pitfalls

- **Aspirational vs. actual target group:** Website says "Enterprise" but actual customers are freelancers and SMBs. Testimonials and customer references show reality.
- **Target group expansion:** Some providers start B2C and want to go B2B. Watch for signals like new "For teams" pages, team plans, or enterprise contact forms.
- **DACH specifics:** In the German-speaking market, there's a strong separation between "Weiterbildung" (professional, often employer-paid) and "Fortbildung"/"Kurse" (privately paid). Website wording reveals the target group.

## Quality Checks

- B2B vs. B2C clearly identified?
- Target group derived from real signals (testimonials, customers, pricing) – not just marketing text?
- Overlap with own target audience assessed?
- Geographic focus clear (DACH, Europe, Global)?
