---
name: research-strengths-weaknesses
description: >
  Create SWOT analyses for competitors in CompetitiveOS. Use when deriving strengths, weaknesses,
  opportunities, and threats from existing competitor data. This skill synthesizes findings from
  other dimensions – load it AFTER company_profile, pricing, product, and target_audience data
  has been captured for the competitor.
---

# Research: Strengths & Weaknesses (strengths_weaknesses)

Create a source-backed assessment of a competitor's strengths, weaknesses, opportunities, and threats. Always in relation to the user's own offering.

## Important: This Dimension Builds on Others

Strengths & weaknesses are NOT independent research – they are a **synthesis** of data points from the other dimensions. Create SWOT entries only AFTER you've captured the other active dimensions (pricing, product, company_profile, target_audience) for the competitor.

## SWOT Types

Use `add_strength_weaknesses(competitor_id, entries[])` (batch) to add all SWOT entries in one call. For single entries, use `add_strength_weakness(competitor_id, type, description, evidence, source_url)`.

| Type | Priority | Description | Example |
|---|---|---|---|
| `strength` | required (2+) | What is the competitor strong at? | "4.8/5 stars on Trustpilot with 500+ reviews" |
| `weakness` | required (2+) | What is the competitor weak at? | "No live coaching – only on-demand content" |
| `opportunity` | recommended (1-2) | What opportunities does the competitor have? | "Enterprise expansion: new team plans launched" |
| `threat` | recommended (1-2) | What threat does the competitor pose to US? | "40% cheaper with similar feature set" |

> **Priority Guide:** At minimum, capture 2 strengths + 2 weaknesses (`required`). Add 1-2 opportunities + 1-2 threats as `recommended` scope. Further detail is `optional`. Use the batch tool `add_strength_weaknesses` when adding 3+ entries.

## How to Derive SWOT Entries

### Strengths – derive from:
- **Product:** Unique features no other competitor has
- **Pricing:** Particularly good price-performance ratio
- **Customer feedback:** High ratings, frequently praised aspects
- **Market presence:** Large user base, notable customer references
- **Team:** Experienced founders, strong growth (visible in employee count)

### Weaknesses – derive from:
- **Product:** Missing features that others (including us) have
- **Pricing:** Significantly more expensive without clear added value
- **Customer feedback:** Negative reviews, recurring complaints
- **Market presence:** Low visibility, little social media presence
- **Technology:** Outdated platform, poor UX, no mobile app

### Opportunities (of the competitor) – derive from:
- **Trends:** New market segment the competitor could address
- **Product roadmap:** Announced features or partnerships
- **Hiring:** Job postings show strategic direction
- **Funding:** Fresh capital = likely expansion

### Threats (to us) – derive from:
- **Direct competition:** Competitor targets exactly our audience with better/cheaper offer
- **Price pressure:** Competitor lowers prices or offers freemium
- **Feature parity:** Competitor copies our USPs
- **Market entry:** Large player enters our market

## Quality Standards

### Good SWOT entries:
- **Specific:** "4.8/5 on Trustpilot (523 reviews) – particularly praised: practical relevance"
- **Source-backed:** Every entry has `source_url` and `evidence`
- **Relative:** "Offer 120 courses – 3x more than us (45 courses)"
- **Actionable:** "Weakness: No live coaching → our live coaching is a differentiator"

### Bad SWOT entries:
- ❌ "Has a good website" (too vague, no evidence)
- ❌ "Is a strong competitor" (meaningless)
- ❌ Entries without source

## Target Count

Per competitor, aim for:
- 2-4 strengths
- 2-4 weaknesses
- 1-2 opportunities (if identifiable)
- 1-2 threats (if relevant)

Fewer but well-founded entries are better than a long list of weak points.

## Deriving Insights

When you spot patterns across competitors after SWOT analysis, create an insight with `add_insight()`:

- "3 of 5 competitors have no live coaching → our USP confirmed"
- "Market is moving towards Enterprise → 2 competitors launched team plans"
- "Price gap in the 20-35€/month segment – we're the only ones there"
