---
name: research-product
description: >
  Research competitor product portfolios for CompetitiveOS. Use when analyzing features, courses,
  delivery formats, platforms, certifications, unique features, or product updates. Covers
  comparison of feature sets to own profile.
---

# Research: Product Portfolio (product)

Capture what the competitor concretely offers. Which products, courses, features, formats? How is it delivered?

## Data Points to Capture

| Key | Priority | Description | Example |
|---|---|---|---|
| `core_offering` | required | Main product/service in one sentence | "Online course platform for AI training" |
| `product_type` | required | Type of offering | "Online courses", "Coaching", "Platform access", "Bootcamp" |
| `delivery_format` | required | How is it delivered? | "On-demand videos + live sessions" |
| `unique_features` | required | Unique selling points in the product | "AI tutor that corrects assignments" |
| `topics_covered` | recommended | Topic areas | "Python, ML, Data Science, Generative AI" |
| `certification` | recommended | Certification offered? | "Yes, own certificate + IHK cooperation" |
| `languages` | recommended | Available languages | "German, English" |
| `platform` | recommended | Platform/technology | "Custom platform", "Teachable", "Thinkific" |
| `course_count` | optional | Number of courses/modules | "120+ courses" |
| `mobile_app` | optional | Mobile app available? | "Yes, iOS + Android" or "No, web only" |
| `live_coaching` | optional | Live coaching/support included? | "Yes, weekly Q&A sessions" |
| `community` | optional | Community access? | "Slack community for all participants" |

> **Priority Guide:** `required` keys are the minimum for a useful analysis. Start with these under time pressure. `recommended` keys form the standard scope. `optional` keys add depth for comprehensive analyses. Use `add_data_points` (batch) when capturing 3+ data points for the same competitor and dimension.

## Research Sources by Priority

### Primary (Confidence: high)
1. **Product pages** – Systematically go through main navigation (Courses, Products, Features, Offerings). Document each page as source.
2. **Feature comparison page** – Some providers have "Why us?" or comparison pages listing USPs.
3. **Changelogs / blog** – "New features" or "Product updates" posts show development direction.
4. **Demo videos / webinars** – Often public on YouTube or the website. Give real product insight.

### Secondary (Confidence: medium)
5. **App Store / Google Play** – Store description lists features, screenshots show UX.
6. **Comparison portals** – G2, Capterra, OMR Reviews – feature lists and comparison matrices.
7. **YouTube reviews / tutorials** – Content creators often show the product in detail.

### Tertiary (Confidence: low)
8. **Social media posts** – LinkedIn, Twitter/X – product announcements.
9. **Job postings** – Technologies being hired for hint at tech stack and product direction.

## Common Pitfalls

- **Marketing vs. reality:** Product pages promise a lot. Cross-check with user reviews when possible. A feature "exists" only when users confirm it or it's visible in a demo video.
- **Feature depth:** "AI features" can mean anything – from a chat widget to a full AI tutor. Capture depth, not just existence.
- **Outdated info:** Product pages aren't always updated. Check date of last change (footer, blog posts).
- **Freemium differences:** Free tier products are often heavily restricted. Capture differences between Free and Paid.

## Quality Checks

- Core product described in one sentence (not in marketing language)?
- Delivery format clear (online, offline, hybrid, on-demand, live)?
- Unique features identified (what does only this competitor have)?
- Comparison to own product created (which features do we have that they don't – and vice versa)?
