---
name: research-pricing
description: >
  Research competitor pricing models for CompetitiveOS. Use when analyzing prices, plans, discounts,
  free tiers, enterprise pricing, or payment terms. Covers price comparison to own profile,
  historical price changes, and DACH-specific considerations (VAT, currency).
---

# Research: Pricing Model (pricing)

Capture the competitor's complete pricing structure. How do they monetize? What does it cost? How does it compare to the user's own offering?

## Data Points to Capture

| Key | Priority | Description | Example |
|---|---|---|---|
| `pricing_model` | required | Basic model | "Subscription monthly/annual", "One-time payment", "Freemium" |
| `plans` | required | Plans overview | "Basic: 29€/mo, Pro: 79€/mo, Enterprise: on request" |
| `cheapest_plan` | required | Cheapest paid plan | "29€/month" |
| `price_vs_own` | required | Price comparison to own offering | "172% more expensive than our Pro plan (29€)" |
| `has_free_tier` | recommended | Free access available? | "Yes, 7-day trial" or "No" |
| `most_popular_plan` | recommended | Most popular/highlighted plan | "Pro: 79€/mo (marked as 'Popular')" |
| `enterprise_pricing` | recommended | Enterprise/custom pricing | "On request" or "From 499€/mo" |
| `annual_discount` | recommended | Annual payment discount | "20% discount on annual billing" |
| `price_per_user` | optional | Per-user price (if applicable) | "15€/user/month" |
| `hidden_costs` | optional | Hidden costs / add-ons | "Certificate: 49€ extra" |
| `currency` | optional | Currency | "EUR" |

> **Priority Guide:** `required` keys are the minimum for a useful analysis. Start with these under time pressure. `recommended` keys form the standard scope. `optional` keys add depth for comprehensive analyses. Use `add_data_points` (batch) when capturing 3+ data points for the same competitor and dimension.

## Research Sources by Priority

### Primary (Confidence: high)
1. **Pricing page** – Almost every SaaS/online course provider has `/pricing` or `/preise`. Best source. Always document URL.
2. **App Store entries** – Subscription prices visible in App Store / Google Play.
3. **Free signup / trial** – Prices often visible after login. Only sign up if free and no obligation.

### Secondary (Confidence: medium)
4. **Comparison portals** – G2, Capterra, OMR Reviews – often show price ranges.
5. **Wayback Machine** – web.archive.org – Historical pricing pages to detect price changes.
6. **Blog articles / reviews** – Google: "[competitor] pricing review". Often with screenshots.

### Tertiary (Confidence: low)
7. **Forums / Reddit / Social Media** – Users sometimes discuss prices. Outdated but indicative.

## Common Pitfalls

- **"On request" pricing:** Common in B2B and high-priced courses. Capture explicitly: `key: "pricing_transparent", value: "No – price only on request"`. This is itself a valuable data point.
- **Gross vs. net:** DACH B2B often shows net prices, B2C shows gross. Always note whether incl. or excl. VAT.
- **Price changes:** Prices change. Always capture access date. If you find old prices via Wayback Machine, capture both (old + new).
- **Bundles / upsells:** Some providers have cheap entry prices but expensive add-on modules. Compare the full package, not just the base price.
- **Currencies:** DACH market mostly EUR, but Swiss providers in CHF. Always capture currency.

## Quality Checks

- Pricing page linked as source (not from memory)?
- All plans captured (not just the cheapest)?
- Gross/net clearly noted?
- Comparison to own profile created?
- "On request" pricing explicitly captured as data point?
