---
name: research-positioning
description: >
  Research competitor positioning and brand strategy for CompetitiveOS. Use when analyzing USP,
  tagline, brand voice, messaging, market positioning, differentiation, or value proposition.
  Covers how the competitor communicates and differentiates in the market.
---

# Research: Positioning & Brand (positioning)

Capture how the competitor positions itself in the market. What is their unique selling proposition? How do they communicate? How do they differentiate from alternatives (including the user's own product)?

## Data Points to Capture

| Key | Priority | Description | Example |
|---|---|---|---|
| `usp` | required | Unique Selling Proposition | "AI-powered competitive intelligence in real-time" |
| `value_proposition` | required | Core value proposition | "Save 20h/week on competitive research" |
| `positioning_vs_own` | required | Positioning comparison to own | "Positions as enterprise solution vs. our SMB focus" |
| `target_positioning` | required | Where they position (premium/mid/budget) | "Premium segment, enterprise-first" |
| `tagline` | recommended | Main tagline/slogan | "Know your market before your market knows you" |
| `differentiation` | recommended | Key differentiators vs. market | "Only tool with real-time monitoring + AI summaries" |
| `messaging_themes` | recommended | Key messaging themes | "Speed, accuracy, automation" |
| `social_proof` | recommended | Social proof elements used | "500+ enterprise customers, G2 Leader badge" |
| `brand_voice` | optional | Brand voice/tone | "Professional, data-driven, slightly provocative" |
| `competitor_mentions` | optional | How they reference competitors | "Comparison page names 3 competitors directly" |
| `content_positioning` | optional | Content/thought leadership positioning | "Heavy on whitepapers and webinars, positions as thought leader" |

> **Priority Guide:** `required` keys are the minimum for a useful analysis. Start with these under time pressure. `recommended` keys form the standard scope. `optional` keys add depth for comprehensive analyses. Use `add_data_points` (batch) when capturing 3+ data points for the same competitor and dimension.

## Research Sources by Priority

### Primary (Confidence: high)
1. **Homepage** – Hero section, above-the-fold messaging. Best source for tagline, USP, value proposition. Always document URL.
2. **About/Mission page** – Often reveals brand voice, mission, differentiation strategy.
3. **Pricing page copy** – Pricing page headlines and descriptions reveal positioning (e.g. "Enterprise-grade" vs. "For startups").

### Secondary (Confidence: medium)
4. **LinkedIn company page** – Tagline, description, and recent posts reveal messaging themes.
5. **Comparison/alternative pages** – Google: "[competitor] vs [alternative]". Often on their own site. Shows how they differentiate.
6. **G2/Capterra profile** – Their self-written descriptions reveal intended positioning.
7. **Press releases** – How they describe themselves to media.

### Tertiary (Confidence: low)
8. **Blog/Content** – Blog topics and tone reveal thought leadership strategy.
9. **Social media** – Twitter/LinkedIn posts show brand voice in action.
10. **Job postings** – Marketing job descriptions sometimes reveal positioning strategy.

## Common Pitfalls

- **Confusing features with positioning:** "We have AI" is a feature. "The only AI-native CI tool" is positioning. Capture positioning, not feature lists.
- **Ignoring visual positioning:** A minimalist design signals "premium" even without saying it. Note visual brand cues alongside text.
- **Only checking homepage:** Messaging often differs between homepage (awareness), product pages (consideration), and pricing (conversion). Check all three.
- **Outdated messaging:** Companies rebrand. Check the Wayback Machine if the current positioning seems new. Capture both old and new if relevant.
- **Assumed differentiation:** Don't assume "they differentiate on price" without evidence. Look for explicit claims.

## Quality Checks

- Homepage and about page linked as sources?
- USP and tagline captured verbatim (exact quotes)?
- Comparison to own positioning created?
- Brand voice described with specific adjectives, not just "professional"?
- Differentiation backed by evidence (comparison pages, claims)?
