---
name: research-go-to-market
description: >
  Research competitor go-to-market strategy for CompetitiveOS. Use when analyzing sales channels,
  marketing approach, content strategy, SEO, partnerships, distribution, or growth tactics.
  Covers how the competitor acquires and retains customers.
---

# Research: Go-to-Market Strategy (go_to_market)

Capture how the competitor reaches and acquires customers. What channels do they use? How do they market? What is their content strategy? How does this compare to the user's own approach?

## Data Points to Capture

| Key | Priority | Description | Example |
|---|---|---|---|
| `sales_model` | required | Sales model | "Product-led growth with self-serve + sales-assisted enterprise" |
| `marketing_channels` | required | Key marketing channels | "SEO, LinkedIn Ads, webinars, conferences" |
| `content_strategy` | required | Content marketing approach | "Weekly blog, monthly webinar, quarterly report" |
| `gtm_vs_own` | required | GTM comparison to own approach | "Much heavier on outbound sales vs. our inbound-only approach" |
| `sales_channels` | recommended | Active sales channels | "Direct sales, partner resellers, app marketplace" |
| `seo_focus` | recommended | SEO/content focus areas | "Ranks for 'competitive analysis tool', 'market intelligence'" |
| `social_presence` | recommended | Social media presence | "LinkedIn: 12K followers, Twitter: 3.5K, active YouTube" |
| `partnerships` | recommended | Strategic partnerships | "HubSpot integration partner, Salesforce AppExchange" |
| `organic_traffic` | optional | Estimated organic traffic | "~45K monthly visits (SimilarWeb)" |
| `events_conferences` | optional | Event/conference presence | "Sponsor at SaaStr, booth at Web Summit" |
| `free_resources` | optional | Lead magnets/free resources | "Free competitive analysis template, ROI calculator" |
| `referral_program` | optional | Referral/affiliate program | "20% affiliate commission, customer referral credits" |

> **Priority Guide:** `required` keys are the minimum for a useful analysis. Start with these under time pressure. `recommended` keys form the standard scope. `optional` keys add depth for comprehensive analyses. Use `add_data_points` (batch) when capturing 3+ data points for the same competitor and dimension.

## Research Sources by Priority

### Primary (Confidence: high)
1. **Website structure** – Navigation, CTAs, conversion flows reveal GTM priorities. Check /blog, /resources, /partners, /integrations.
2. **SimilarWeb / SEMrush** – Traffic estimates, top pages, traffic sources. Use free versions for basic data.
3. **App marketplaces** – Salesforce AppExchange, HubSpot Marketplace, Zapier – shows integration/partnership strategy.

### Secondary (Confidence: medium)
4. **LinkedIn company page** – Follower count, posting frequency, ad library (LinkedIn Ad Library) for ad strategy.
5. **Google Ads Transparency Center** – Check if they run Google Ads and on which keywords.
6. **Blog/Content hub** – Publishing frequency, topics, quality reveals content strategy investment.
7. **YouTube/Podcast** – Video content strategy, webinar recordings.

### Tertiary (Confidence: low)
8. **Job postings** – Marketing/sales job descriptions reveal GTM priorities (e.g. hiring "Enterprise AEs" = outbound focus).
9. **Social media activity** – Posting frequency and engagement as proxy for social investment.
10. **Review site responses** – Active responses on G2/Capterra indicate customer success investment.

## Common Pitfalls

- **Confusing presence with strategy:** Having a blog doesn't mean content marketing is a core channel. Look for investment signals (frequency, quality, promotion).
- **Traffic estimates are rough:** SimilarWeb/SEMrush numbers are estimates. Capture them but note the source and confidence level.
- **Missing paid channels:** Organic presence is visible, paid isn't. Check Google Ads Transparency and LinkedIn Ad Library explicitly.
- **Regional differences:** DACH market GTM differs from US. Check for German-language content, DACH-specific events, local partnerships.
- **Ignoring indirect channels:** Integrations (Zapier, HubSpot) are a GTM channel. App marketplace listings and reviews are distribution.

## Quality Checks

- At least 3 different marketing channels identified?
- Traffic estimates sourced (not guessed)?
- Comparison to own GTM approach created?
- Partnership/integration strategy captured?
- Content frequency documented with evidence (not assumed)?
