---
name: research-customer-feedback
description: >
  Research competitor customer feedback and satisfaction for CompetitiveOS. Use when analyzing
  reviews, ratings, NPS, support quality, churn signals, or customer sentiment.
  Covers what real customers say about the competitor's product.
---

# Research: Customer Feedback & Satisfaction (customer_feedback)

Capture what real customers say about the competitor. What are the ratings? What do they praise, what do they criticize? How does customer satisfaction compare to the user's own product?

## Data Points to Capture

| Key | Priority | Description | Example |
|---|---|---|---|
| `g2_rating` | required | G2 overall rating | "4.5/5 (234 reviews)" |
| `review_volume` | required | Total review volume across platforms | "~500 reviews total across G2, Capterra, Trustpilot" |
| `top_praise` | required | Most frequently praised aspects | "Easy to use, great visualizations, fast support" |
| `top_complaints` | required | Most common complaints | "Expensive, steep learning curve, limited integrations" |
| `capterra_rating` | recommended | Capterra overall rating | "4.3/5 (89 reviews)" |
| `trustpilot_rating` | recommended | Trustpilot rating | "3.8/5 (156 reviews)" |
| `support_quality` | recommended | Support quality perception | "Mixed – fast response but limited depth according to reviews" |
| `customer_feedback_vs_own` | recommended | Feedback comparison to own | "Higher ratings on ease-of-use, lower on pricing satisfaction" |
| `app_store_rating` | optional | App Store rating | "4.2/5 (1.2K ratings)" |
| `nps_score` | optional | NPS score (if publicly available) | "NPS 42 (published on their site)" |
| `churn_signals` | optional | Churn/dissatisfaction indicators | "Multiple reviews mention switching away due to pricing changes" |

> **Priority Guide:** `required` keys are the minimum for a useful analysis. Start with these under time pressure. `recommended` keys form the standard scope. `optional` keys add depth for comprehensive analyses. Use `add_data_points` (batch) when capturing 3+ data points for the same competitor and dimension.

## Research Sources by Priority

### Primary (Confidence: high)
1. **G2** – Most comprehensive B2B review platform. Check ratings, pros/cons, alternatives mentioned. Filter by recency.
2. **Capterra** – Second major B2B review platform. Different reviewer base than G2. Check overall and category ratings.
3. **Trustpilot** – More consumer-focused but useful for B2C/prosumer products. Check rating distribution.
4. **App Store / Google Play** – Mobile app reviews reveal UX issues and feature gaps. Sort by recent.

### Secondary (Confidence: medium)
5. **OMR Reviews** – Important for DACH market specifically. German-language reviews.
6. **Product Hunt** – Launch reception, initial feedback, early adopter sentiment.
7. **Reddit** – Search: "site:reddit.com [competitor name] review". Unfiltered user opinions.
8. **Twitter/X** – Search: "[competitor] from:* (love OR hate OR terrible OR amazing)". Real-time sentiment.

### Tertiary (Confidence: low)
9. **Quora / Forums** – Older discussions, may be outdated but reveal historical sentiment trends.
10. **YouTube reviews** – Independent reviewer opinions, often more detailed than text reviews.

## Common Pitfalls

- **Review recency matters:** A 4.5 rating from 2 years ago means little if recent reviews trend negative. Always check the date distribution.
- **Fake/incentivized reviews:** Watch for suspiciously positive reviews posted in clusters. G2 marks "incentivized" reviews – note this.
- **Selection bias:** People who leave reviews tend to have strong opinions (very happy or very unhappy). The silent middle is missing.
- **Comparing apples to oranges:** Different products get reviewed by different audiences. A developer tool's 4.0 may be excellent, while a consumer app's 4.0 is mediocre.
- **Missing DACH-specific feedback:** English reviews dominate. Explicitly search for German-language reviews on OMR Reviews, Trustpilot DE, and Google Maps (for local businesses).

## Quality Checks

- At least 2 review platforms checked and sourced?
- Review counts and dates documented (not just star rating)?
- Top praise AND top complaints captured (not just positive)?
- Recent reviews specifically checked (last 6 months)?
- Comparison to own customer feedback created?
