---
name: research-company-profile
description: >
  Research competitor company profiles for CompetitiveOS. Use when analyzing company basics:
  founding year, legal entity, headquarters, team size, funding, CEO/founders. Covers DACH-specific
  sources like Handelsregister, Bundesanzeiger, North Data, and Impressum.
---

# Research: Company Profile (company_profile)

Capture the competitor's basic data: who they are, how big they are, who's behind them.

## Data Points to Capture

| Key | Priority | Description | Example |
|---|---|---|---|
| `company_name` | required | Official company name | "StackFuture GmbH" |
| `founding_year` | required | Year founded | "2019" |
| `headquarters` | required | HQ (city, country) | "Berlin, Germany" |
| `employee_count` | required | Employee count (estimate) | "~25" |
| `ceo_founder` | recommended | CEO / Founder | "Max Mustermann (CEO & Founder)" |
| `funding` | recommended | Funding / investors | "Bootstrapped" or "Series A, 5M€" |
| `website` | recommended | Main website | "stackfuture.de" |
| `description` | recommended | Short description (1-2 sentences) | "AI training platform for enterprises" |
| `legal_form` | optional | Legal form | "GmbH", "UG", "Einzelunternehmen" |
| `revenue_estimate` | optional | Revenue estimate (if available) | "1-5M€ ARR (estimated)" |
| `linkedin_url` | optional | LinkedIn company page | URL |

> **Priority Guide:** `required` keys are the minimum for a useful analysis. Start with these under time pressure. `recommended` keys form the standard scope. `optional` keys add depth for comprehensive analyses. Use `add_data_points` (batch) when capturing 3+ data points for the same competitor and dimension.

## Research Sources by Priority

### Primary (Confidence: high)
1. **Website Impressum** – Mandatory in DE/AT/CH: company name, legal form, managing director, trade register number, address. Always check first.
2. **Handelsregister / Bundesanzeiger** – handelsregister.de or bundesanzeiger.de for annual reports (GmbH/AG only). Provides revenue, employee count, founding date.
3. **North Data** – northdata.de – Aggregates trade register data, shows connections between companies and people.

### Secondary (Confidence: medium)
4. **LinkedIn Company Page** – Employee count estimate ("X employees on LinkedIn"), location, description, recent posts.
5. **Crunchbase** – crunchbase.com – Funding rounds, investors, founding date (mainly tech/startups).
6. **Press releases** – Google News search for company name. Hints on funding, partnerships, expansion.

### Tertiary (Confidence: low)
7. **Kununu** – kununu.com – Employer reviews give hints on company size and culture.

## Common Pitfalls

- **Solo entrepreneurs without Impressum:** Common in DACH education/coaching. The person IS the key data point.
- **LinkedIn employee count overstates:** Includes former employees and freelancers. Always mark as estimate.
- **Holding structures:** Companies may operate under a brand name different from the legal entity. Impressum shows the legal entity.
- **Austria/Switzerland:** Different trade registers. AT: Firmenbuch (justiz.gv.at). CH: Zefix (zefix.ch).

## Quality Checks

- Company name and legal form from Impressum (not guessed)?
- At least one official source (Impressum, trade register)?
- Founding year backed by source?
- Employee count marked as estimate if not from official source?
