# CompetitiveOS – Tool Reference

## Session Tools

| Tool | Purpose |
|---|---|
| `list_analyses` | List available analyses |
| `set_active_analysis(analysis_id)` | Set analysis context |
| `get_active_analysis()` | Load current context + own profile (ALWAYS at start) |
| `get_own_profile()` | Load own profile separately (when more detail needed) |

## Competitor Tools

| Tool | Purpose |
|---|---|
| `add_competitor(name, website, description)` | Create new competitor |
| `get_competitor(competitor_id)` | Load single competitor with all details by ID |
| `get_competitor_by_name(name)` | Search competitor by name (preferred when no ID known) |
| `list_competitors()` | Overview of all competitors |
| `add_data_point(competitor_id, dimension, key, value, source_url?, source_title?, source_quote?)` | Add single data point + optionally create & link source in one step |
| `add_data_points(competitor_id, dimension, data_points[])` | Batch: Add multiple data points for one competitor + dimension in one call. Preferred over single `add_data_point` when adding 3+ points. Each entry supports key, value, confidence, value_type, source_url, source_title, source_quote. Max 30 per call. |
| `update_data_point(data_point_id, new_value, source_url?, source_title?, source_quote?)` | Update existing data point (returns diff) |
| `get_data_by_dimension(dimension)` | All data for a dimension across own profile AND competitors |
| `add_strength_weakness(competitor_id, type, description, evidence, source_url)` | Add single SWOT entry (type: strength\|weakness\|opportunity\|threat) |
| `add_strength_weaknesses(competitor_id, entries[])` | Batch: Add multiple SWOT entries for one competitor in one call. Preferred over single `add_strength_weakness` when adding 3+ entries. Each entry supports type, description, evidence, source_url. Max 20 per call. |
| `add_insight(title, description, related_competitor_ids, source_url?)` | Save strategic insight |

## Source Tools

| Tool | Purpose |
|---|---|
| `add_source(url, title, type, accessed_at)` | Register source separately (type: website\|article\|review\|social\|report\|manual) |
| `link_source(source_id, data_point_id, quote?)` | Link existing source to data point |
| `get_sources(competitor_id?)` | List all sources, optionally filtered by competitor |
| `flag_outdated(source_id, reason)` | Mark source as potentially outdated |
| `verify_source(source_id)` | Mark source as verified |

## History Tools

| Tool | Purpose |
|---|---|
| `get_changelog(since?, until?, actor_filter?)` | View change history |
| `rollback(change_id)` | Undo a single change |

## Error Codes

| Code | Meaning | Suggestion |
|---|---|---|
| `NO_ACTIVE_ANALYSIS` | No analysis set in session | Use `list_analyses` + `set_active_analysis` |
| `ANALYSIS_NOT_FOUND` | Analysis ID doesn't exist | Use `list_analyses` |
| `ACCESS_DENIED` | No permission | Contact workspace admin |
| `COMPETITOR_NOT_FOUND` | Competitor ID doesn't exist | Use `list_competitors` or `get_competitor_by_name` |
| `COMPETITOR_EXISTS` | Competitor with same name exists | Use `get_competitor` with existing ID |
| `DATA_POINT_NOT_FOUND` | Data point ID doesn't exist | Use `get_competitor` to see data points |
| `DATA_POINT_EXISTS` | Data point with same dimension+key exists | Use `update_data_point` |
| `DATA_POINT_IS_MANUAL` | Data point manually overridden | Agent updates blocked for this value |
| `INVALID_DIMENSION` | Dimension doesn't exist or isn't activated | Error includes list of valid dimensions |
| `INVALID_TYPE` | Invalid type for strength_weakness | Valid: strength, weakness, opportunity, threat |
| `SOURCE_NOT_FOUND` | Source ID doesn't exist | Use `add_source` or `get_sources` |
| `LINK_EXISTS` | Source-datapoint link already exists | Already linked |
| `CHANGE_NOT_FOUND` | Change ID doesn't exist | Use `get_changelog` |
| `ALREADY_ROLLED_BACK` | Change already undone | No action needed |
| `PARTIAL_BATCH_RESULT` | Some items in a batch failed | Check created/skipped/failed arrays in response |
